package bmci.esign.backendend.models;


import bmci.esign.backendend.models.enums.EStatusLabel;
import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;


@AllArgsConstructor
@NoArgsConstructor
@ToString
@Data
public class ResponseModelStandard<T> {
    private String status_code ;
    private String status_label;
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private T response_data;


    public ResponseModelStandard(String status_code, String status_label) {
        if(status_code.equals("Exception")){
            this.status_code= "009";
        }else{
            this.status_code= status_code;
        }
        this.status_label= status_label;
    }
    public ResponseModelStandard(String status_code) {
        this.status_code= status_code;
        this.status_label= EStatusLabel.status.get(status_code);
    }
    public ResponseModelStandard(String status_code, T response_data) {
        this.status_code= status_code;
        this.status_label= EStatusLabel.status.get(status_code);
        this.response_data= response_data;
    }
}
