package bmci.esign.backendend.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.vladmihalcea.hibernate.type.json.JsonBinaryType;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.*;
import javax.persistence.*;
import javax.persistence.Entity;
import java.io.Serializable;
import java.util.HashMap;

@Data
@AllArgsConstructor @NoArgsConstructor
@TypeDefs({
        @TypeDef(name = "jsonb", typeClass = JsonBinaryType.class)
})
@Entity
public class Position extends AuditorEntity implements Serializable {
    @ManyToOne
    @JoinColumn(name = "destinataire_id") @JsonIgnore
    private Destinataire destinataire;
    @Type(type = "jsonb")
    @Column(columnDefinition = "jsonb")
    private HashMap<String, Object> information;

}
