package bmci.esign.backendend.models;


import bmci.esign.backendend.models.enums.EMailStatus;
import lombok.*;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
@Entity
public class MailRequest extends AuditorEntity implements Serializable {
    private String destination;
    private String email_type;
    private long demandeId;
    private String processCamundaId;
    @Column(unique = true)
    private String token;
//    private String expiration_date;
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "expiration_date")
    private Date expirationDate;

    private String name;
    private String userMessage;
    private EMailStatus status;
    private String responseMessage;
    private String url_sign;

//    @ManyToOne(fetch = FetchType.LAZY)
//    @JoinColumn(name = "demande_id")
//    private Demande demande;
    @Override
    public String toString() {
        return "MailRequest{" +
                "destination='" + destination + '\'' +
                ", email_type='" + email_type + '\'' +
                ", demandeId=" + demandeId +
                ", processCamundaId='" + processCamundaId + '\'' +
                ", token='" + token + '\'' +
                ", expirationDate=" + expirationDate +
                ", name='" + name + '\'' +
                ", userMessage='" + userMessage + '\'' +
                ", status=" + status +
                ", responseMessage='" + responseMessage + '\'' +
                ", url_sign='" + url_sign + '\'' +
                ", id=" + id +
                ", creationDate=" + creationDate +
                ", modificationDate=" + modificationDate +
                '}';
    }
}
