package bmci.esign.backendend.models;

import bmci.esign.backendend.models.enums.EDemande;
import bmci.esign.backendend.models.enums.EStatut;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.*;

import javax.persistence.*;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@NoArgsConstructor
@AllArgsConstructor
@Getter
@Setter
@Builder
@Entity
public class Demande extends AuditorEntity implements Serializable {
    private String confidentiality;
    private String priority;
    private String objetMail;
    private String message;

    @Enumerated(EnumType.STRING)
    @Column(length = 50)
    private EStatut statut;

    @Enumerated(EnumType.STRING)
    @Column(length = 50)
    private EDemande edemande;

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "user_id")
    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    private User user;

    @ManyToOne
    @JoinColumn(name = "typeDocument_id")
    private TypeDocument typeDocument;

    @Temporal(TemporalType.TIMESTAMP)
    private Date expirationDate;

    @OneToMany(mappedBy = "demande", fetch = FetchType.LAZY)
    private List<Destinataire> destinataires = new ArrayList<>();

    @OneToMany(mappedBy = "demande", fetch = FetchType.LAZY)
    private List<Document> documents = new ArrayList<>();

    @Override
    public String toString() {
        return "Demande{" +
                "confidentiality='" + confidentiality + '\'' +
                ", priority='" + priority + '\'' +
                ", objetMail='" + objetMail + '\'' +
                ", message='" + message + '\'' +
                ", statut=" + statut +
                ", edemande=" + edemande +
                ", user=" + user +
                ", typeDocument=" + typeDocument +
                ", expirationDate=" + expirationDate +
                ", destinataires=" + destinataires +
                ", documents=" + documents +
                ", id=" + id +
                ", creationDate=" + creationDate +
                ", modificationDate=" + modificationDate +
                '}';
    }
}
