package bmci.esign.backendend.dto.services;
import bmci.esign.backendend.dto.DestinataireDto;
import bmci.esign.backendend.dto.DocumentDto;
import bmci.esign.backendend.dto.response.DashboardChart;
import bmci.esign.backendend.dto.response.GlobalTableDto;
import bmci.esign.backendend.models.Demande;
import bmci.esign.backendend.models.Destinataire;
import bmci.esign.backendend.models.Document;
import bmci.esign.backendend.models.User;
import bmci.esign.backendend.models.enums.EStatut;
import org.modelmapper.Conditions;
import org.modelmapper.ModelMapper;
import org.modelmapper.convention.MatchingStrategies;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;


@Service
public class MapClassWithDto<E, D> implements IMapClassWithDto<E, D> {

    @Autowired
    private ModelMapper modelMapper;


    @Override
    public D convertToDto(E entity, Class<D> dtoClass) {
        if(entity == null){
            return null;
        }
        modelMapper.getConfiguration().setMatchingStrategy(MatchingStrategies.STRICT).setPropertyCondition(Conditions.isNotNull());
        return modelMapper.map(entity,dtoClass);
    }

    @Override
    public E convertToEntity(D dto, Class<E> entityClass) {
        if(dto == null)
            return null;

        modelMapper.getConfiguration().setMatchingStrategy(MatchingStrategies.STRICT).setPropertyCondition(Conditions.isNotNull());
        return modelMapper.map(dto, entityClass);
    }

    @Override
    public List<D> convertListToListDto(Collection<E> entityList, Class<D> outCLass) {
        if(entityList == null)
            return Collections.emptyList();

        return entityList.stream().map(entity -> convertToDto(entity, outCLass)).collect(Collectors.toList());
    }

    @Override
    public List<D> convertPageToListDto(Page<E> entityList, Class<D> outCLass) {
        if(entityList == null)
            return Collections.emptyList();

        return entityList.stream().map(entity -> convertToDto(entity, outCLass)).collect(Collectors.toList());
    }

    @Override
    public List<E> convertListToListEntity(Collection<D> dtoList, Class<E> outCLass) {
        if(dtoList == null)
            return Collections.emptyList();

        return dtoList.stream().map(dto -> convertToEntity(dto, outCLass)).collect(Collectors.toList());
    }

    @Override
    public Page<D> convertResponseToPageDto(Page<E> entityPage, Class<D> outClass) {
        List<D> dtoList = entityPage.stream()
            .map(entity -> convertToDto(entity, outClass))
            .collect(Collectors.toList());

        Pageable pageable = PageRequest.of(entityPage.getNumber(), entityPage.getSize(), entityPage.getSort());

        return new PageImpl<>(dtoList, pageable, entityPage.getTotalElements());
    }

    public List<DashboardChart> mappingData(List<DashboardChart> chartList){
        Map<String, Integer> map=chartList.stream().collect(Collectors.toMap(DashboardChart::getStatut, DashboardChart::getCount));
        for(EStatut eStatut: EStatut.values()){
            if(!map.containsKey(eStatut.name())){
                map.put(eStatut.name(), 0);
            }
        }
        return map.entrySet().stream().map(entry -> new DashboardChart() {
            @Override
            public int getCount() {
                return entry.getValue();
            }

            @Override
            public String getStatut() {
                return entry.getKey();
            }
        }).collect(Collectors.toList());
    }
//    public Page<GlobalTableDto> convertResponseToPageDto(Page<Demande> demandes, Class<GlobalTableDto> dtoClass, User currentUser) {
//        return demandes.map(demande -> {
//                GlobalTableDto dto = modelMapper.map(demande, dtoClass);
//                dto.setCurrentUser(currentUser);
//                dto.setDemandeTypeBasedOnUser(currentUser);
//                return dto;
//            });
//    }

}