package bmci.esign.backendend.dto.services;
import bmci.esign.backendend.dto.response.DashboardChart;
import bmci.esign.backendend.dto.response.GlobalTableDto;
import bmci.esign.backendend.models.Demande;
import bmci.esign.backendend.models.User;
import org.springframework.data.domain.Page;

import java.util.Collection;
import java.util.List;

public interface IMapClassWithDto<E,D> {

    D convertToDto(E entity, Class<D> dtoClass);

    E convertToEntity(D dto, Class<E> entityClass);

    List<D> convertListToListDto(Collection<E> entityList, Class<D> outCLass);

    List<D> convertPageToListDto(Page<E> entityList, Class<D> outCLass);

    List<E> convertListToListEntity(Collection<D> dtoList, Class<E> outCLass);

    Page<D> convertResponseToPageDto(Page<E> entityList, Class<D> outCLass);
    List<DashboardChart> mappingData(List<DashboardChart> chartList);
}
