package bmci.esign.backendend.dto.response;

import bmci.esign.backendend.dto.DestinataireDto;
import bmci.esign.backendend.dto.DocumentDto;
import bmci.esign.backendend.models.TypeDocument;
import bmci.esign.backendend.models.User;
import bmci.esign.backendend.models.enums.EStatut;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
public class GlobalTableDto implements Serializable {
    private Long id;
    private String confidentiality;
    private String priority;
    private String objetMail;
    private String message;
    @JsonFormat(pattern = "yyyy-MM-dd'T'HH:mm:ss.SSSZ")
    private Date creationDate;

    private String demandeType;

    private TypeDocument typeDocument;

    private List<DestinataireDto> destinataires;

    private EStatut statut;

    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date expirationDate;

    private List<DocumentDto> documents;


    private User currentUser;


    public void setDemandeTypeBasedOnUser(boolean isSender, boolean isRecipient) {
        if (isSender) {
            this.demandeType = "Demande des signatures";
        } else if (isRecipient) {
            this.demandeType = "Demandes à signer";
        } else {
            this.demandeType = "";
        }
    }

    @Override
    public String toString() {
        return "GlobalTableDto{" +
                "id=" + id +
                ", creationDate=" + creationDate +
                ", demandeType=" + demandeType +
                ", statut='" + statut + '\'' +
                ", typeDocument=" + typeDocument +
                ", expirationDate=" + expirationDate +
                ", destinataires=" + destinataires +
                ", documents=" + documents +
                '}';
    }
}
