package bmci.esign.backendend.dto;

import bmci.esign.backendend.models.Destinataire;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.Type;

import javax.persistence.Column;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

@Data @AllArgsConstructor
@NoArgsConstructor
public class PositionDto {
    private Long id;
    @JsonIgnore
    private Destinataire destinataire;
    @Type(type = "jsonb")
    @Column(columnDefinition = "jsonb")
    private  HashMap<String, Object> information;
    @JsonFormat(pattern = "yyyy-MM-dd'T'HH:mm:ss.SSSZ")
    private Date creationDate;
    @JsonFormat(pattern = "yyyy-MM-dd'T'HH:mm:ss.SSSZ")
    private Date modificationDate;
}
