package bmci.esign.backendend.controllers;

import bmci.esign.backendend.dto.DemandeDto;
import bmci.esign.backendend.dto.SignaturePageDto;
import bmci.esign.backendend.dto.services.IMapClassWithDto;
import bmci.esign.backendend.models.Demande;
import bmci.esign.backendend.models.MailRequest;
import bmci.esign.backendend.models.ResponseModelStandard;
import bmci.esign.backendend.models.enums.EMailStatus;
import bmci.esign.backendend.models.enums.EStatut;
import bmci.esign.backendend.repositories.MailRequestRepository;
import bmci.esign.backendend.services.DemandeService;
import bmci.esign.backendend.services.UploadService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.net.MalformedURLException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/upload")
public class UploadController {

    @Value("${file.upload-dir.access}")
    private String UPLOAD_DIR;
    @Autowired
    private UploadService uploadService;
    @Autowired
    private MailRequestRepository mailRequestRepository;
    @Autowired
    private DemandeService demandeService;
    @Autowired
    private IMapClassWithDto<Demande, DemandeDto> demandeMapping;


    public UploadController(UploadService uploadService) {
        this.uploadService = uploadService;
    }

    @PostMapping("/pdf")
    public ResponseModelStandard<String> uploadFile(@RequestParam("file") MultipartFile file) {
        try {
            if (file.isEmpty()) {
                return new ResponseModelStandard<>("099", "The file is empty.");
            }
            String fileDownloadUri = uploadService.uploadFile(file);
            return new ResponseModelStandard<>("000", fileDownloadUri);
        } catch (Exception ex) {
            return new ResponseModelStandard<>("099", "Error downloading file");
        }
    }

    @GetMapping("/documents/{fileName}")
    public ResponseEntity<Resource> downloadFile(@PathVariable String fileName) {
        try {
            Path filePath = Paths.get(UPLOAD_DIR).resolve(fileName).normalize();
            Resource resource = new UrlResource(filePath.toUri());

            if (resource.exists() && resource.isReadable()) {
                return ResponseEntity.ok()
                        .contentType(MediaType.APPLICATION_PDF)
                        .header(HttpHeaders.CONTENT_DISPOSITION, "inline; filename=\"" + resource.getFilename() + "\"")
                        .body(resource);
            } else {
                return ResponseEntity.notFound().build();
            }
        } catch (MalformedURLException ex) {
            return ResponseEntity.status(500).body(null);
        }
    }

    @PostMapping("/modifyPdf/{token}")
    public ResponseModelStandard<Long> modifyPdfbyToken(@RequestBody List<SignaturePageDto> signaturePageDtos, @PathVariable String token) {
        MailRequest mailRequest = mailRequestRepository.findByToken(token);
        if(mailRequest != null){
            if(mailRequest.getStatus().equals(EMailStatus.SENT)){
                mailRequest.setStatus(EMailStatus.CLICKED);
                mailRequestRepository.save(mailRequest);
            }
            DemandeDto demandeDto = demandeService.getDemande(mailRequest.getDemandeId());
            if(demandeDto.getStatut().equals(EStatut.COMPLETE.name())){
                return new ResponseModelStandard<>("014");
            }else if(demandeDto.getStatut().equals(EStatut.CANCELED.name())){
                return new ResponseModelStandard<>("015");
            }
            if(demandeDto.getExpirationDate().compareTo(new Date()) < 0){
                return new ResponseModelStandard<>("013");
            }
            demandeDto.setDestinataires(
                    demandeDto.getDestinataires().stream().filter(destinataireDto -> destinataireDto.getEmail().equals(mailRequest.getDestination())).collect(Collectors.toList()));
            String var = uploadService.modifyPdf(signaturePageDtos,demandeDto);
            if(var.equals("success")){
                Demande demande = demandeService.findDemande(mailRequest.getDemandeId());
                demandeService.processEmail(demande);
                return new ResponseModelStandard<>("000");
            }else if(var.equals("cancel")){
                DemandeDto demandeDto1 = demandeService.getDemande(mailRequest.getDemandeId());
                demandeDto1.setStatut(EStatut.CANCELED.name());
                demandeService.updateDemande(demandeDto1, demandeDto1.getId());
            }
            return new ResponseModelStandard<>("015");

        }else{
            return new ResponseModelStandard<>("012");
        }
    }

}
