package bmci.esign.backendend.controllers;

import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngines;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.Map;

@RestController
@RequestMapping("/tasks")
public class TaskController {

    // Define the process definition key
    private static final String PROCESS_DEFINITION_KEY = "esignapp-process";

    // Autowire TaskService for managing tasks
    @Autowired
    private TaskService taskService;


    // Instance ID to track process instances
    static String instanceId = "";

    // Endpoint to start a process instance
    @GetMapping("/demarrer-proccess")
    public ResponseEntity<String> demarrerProccess() {
        ProcessEngine processEngine = ProcessEngines.getDefaultProcessEngine();
        RuntimeService runtimeService = processEngine.getRuntimeService();
        // Define process variables
        Map<String, Object> processVariables = new HashMap<>();
        processVariables.put("operationidworkflow", "next");
        // Start a new process instance
        ProcessInstance pi = runtimeService.startProcessInstanceByKey(PROCESS_DEFINITION_KEY, processVariables);
        // Get the process instance key
        String processInstanceKey = pi.getProcessInstanceId();
        // Create a response message including the process instance key
        String responseMessage = "Le processus a démarré avec la clé : " + processInstanceKey;
        // Store the process instance ID for future reference
        instanceId = processInstanceKey;
        // Return a success response
        return ResponseEntity.ok("User task completed successfully" + responseMessage);
    }


    // Endpoint to add a demand
    @GetMapping("/adddemande/{instance}")
    public ResponseEntity<String> adddemande(@PathVariable(name = "instance") String key) {
        try {
            // Query for the user task associated with the process instance and assigned to the specified user
            Task userTask = taskService.createTaskQuery()
                    .processInstanceId(key)
                    .taskCandidateUser("demo")
                    .singleResult();

            if (userTask != null) {
                // Set a process variable
                taskService.setVariable(userTask.getId(), "variableName", "variable ");
                // Complete the user task
                taskService.complete(userTask.getId());
                return ResponseEntity.ok("User task adddemande completed");
            } else {
                return ResponseEntity.badRequest().body("No user task found for the specified process instance and assignee");
            }
        } catch (Exception e) {
            return ResponseEntity.badRequest().body("Error completing user task: " + e.getMessage());
        }
    }


    // Endpoint to e-sign a file
    @GetMapping("/esignfile/{instance}/{operation}")
    public ResponseEntity<String> esignfile(@PathVariable(name = "instance") String key, @PathVariable(name = "operation") String operation) {
        try {
            // Query for the user task associated with the process instance and assigned to the specified user
            Task userTask = taskService.createTaskQuery()
                    .processInstanceId(key)
                    .taskDefinitionKey("Activity_0gktoje")
                    .singleResult();

            if (userTask != null) {
                // Set a process variable
                taskService.setVariable(userTask.getId(), "operationidworkflow", operation);
                // Complete the user task
                taskService.complete(userTask.getId());
                return ResponseEntity.ok("esignfile completed");
            } else {
                return ResponseEntity.badRequest().body("No user task found for the specified process instance and assignee");
            }
        } catch (Exception e) {
            return ResponseEntity.badRequest().body("Error completing user task: " + e.getMessage());
        }
    }


}
