package bmci.esign.backendend.controllers;

import bmci.esign.backendend.dto.SignatureDto;
import bmci.esign.backendend.models.ResponseModelStandard;
import bmci.esign.backendend.services.SignatureService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;


@RestController
@RequestMapping("/signature")
public class SignatureController {
    private final SignatureService signatureService;

    public SignatureController(SignatureService signatureService) {
        this.signatureService = signatureService;
    }

    @PostMapping("/add")
    public ResponseModelStandard<Long> addSignature(@RequestBody SignatureDto signatureDto){
        try {
            signatureService.addSignature(signatureDto);
            return new ResponseModelStandard<>("000");
        }catch (Exception e){
            return new ResponseModelStandard<>("099");
        }
    }


    @GetMapping("/get")
    public ResponseModelStandard<SignatureDto> getSignature(@RequestParam(name = "id") Long id){
        try {
            return new ResponseModelStandard<>("000", signatureService.findByUserId(id));
        }catch (Exception e){
            return new ResponseModelStandard<>("099");
        }
    }


}
