package bmci.esign.backendend.config;

import bmci.esign.backendend.services.DemandeService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

@Component
@EnableAsync
@EnableScheduling
@Slf4j
public class ScheduleService {

    private final DemandeService demandeService;

    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("HH:mm:ss");

    public ScheduleService(DemandeService demandeService) {
        this.demandeService = demandeService;
    }

    @Scheduled(cron = "0 0 9 * * *", zone = "Africa/Casablanca")
    public void scheduleTaskWithFixedDelay(){
        log.info("Fixed Task :: Execution Time - {}", dateTimeFormatter.format(LocalDateTime.now()));
    //    demandeService.findDemandesByExpirationDateBeforeAndStatut
        demandeService.cancelExpiredDm();
    }

    @Scheduled(cron = "0 28 17 * * *", zone = "Africa/Casablanca")
    public void scheduleExpiredSoonTask(){
        log.info("Fixed Expired Soon Task :: Execution Time - {}", dateTimeFormatter.format(LocalDateTime.now()));
        demandeService.findExpiringTomorrow();
      //  demandeService.cancelExpiredDm();
    }
}
