package bmci.esign.backendend.models.enums;

public enum EPriority {
    URGENT("urgent");
    private final String displayName;
    EPriority(String displayName) {
        this.displayName = displayName;
    }
    public static EPriority fromString(String text) {
        for (EPriority category : EPriority.values()) {
            if (category.displayName.equalsIgnoreCase(text)) {
                return category;
            }
        }
        throw new IllegalArgumentException("No constant with text " + text + " found");
    }
}
