package bmci.esign.backendend.models.enums;

public enum EDemande {
    PARALLELE("En parallèle"),
    SEQUENCE("En séquence"),
    SIMULTANEE("En simultanée");

    private final String displayName;
    EDemande(String displayName) {
        this.displayName = displayName;
    }
    public String getDisplayName() {
        return displayName;
    }
    public static EDemande fromString(String text) {
        for (EDemande statut : EDemande.values()) {
            if (statut.displayName.equalsIgnoreCase(text)) {
                return statut;
            }
        }
        throw new IllegalArgumentException("No constant with text " + text + " found");
    }
}
