package bmci.esign.backendend.controllers;

import bmci.esign.backendend.dto.DemandeDto;
import bmci.esign.backendend.models.MailRequest;
import bmci.esign.backendend.models.ResponseModelStandard;
import bmci.esign.backendend.models.enums.EMailStatus;
import bmci.esign.backendend.models.enums.ENotification;
import bmci.esign.backendend.models.enums.EStatut;
import bmci.esign.backendend.repositories.MailRequestRepository;
import bmci.esign.backendend.services.DemandeService;
import bmci.esign.backendend.services.NotificationService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Date;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/token")
@Slf4j
public class TokenController {

    private final MailRequestRepository mailRequestRepository;
    private final DemandeService demandeService;
    private final NotificationService notificationService;

    public TokenController(MailRequestRepository mailRequestRepository, DemandeService demandeService, NotificationService notificationService) {
        this.mailRequestRepository = mailRequestRepository;
        this.demandeService = demandeService;
        this.notificationService = notificationService;
    }


    @GetMapping("/getToken")
    public ResponseModelStandard<DemandeDto> getToken(@RequestParam(name = "token") String token){
        log.info("getToken {}",token);
        MailRequest mailRequest = mailRequestRepository.findByToken(token);
              log.info("mailRequest {}",mailRequest);
        if(mailRequest != null){
            if(mailRequest.getStatus().equals(EMailStatus.SENT)){
                mailRequest.setStatus(EMailStatus.CLICKED);
                log.info("CLICKED");
                mailRequestRepository.save(mailRequest);
                log.warn("CHANGE NOTIFICATION STATUS");
                notificationService.changeStatusByDmId(null, mailRequest.getDemandeId(), mailRequest.getDestination(),ENotification.VIEW);
            }
            DemandeDto demandeDto = demandeService.getDemande(mailRequest.getDemandeId());
            if(demandeDto.getStatut().equals(EStatut.COMPLETE.name())){
                return new ResponseModelStandard<>("014");
            }else if(demandeDto.getStatut().equals(EStatut.CANCELED.name())){
                return new ResponseModelStandard<>("015");
            }
            if(demandeDto.getExpirationDate().compareTo(new Date()) < 0){
                return new ResponseModelStandard<>("013");
            }
        demandeDto.setDestinataires(
                demandeDto.getDestinataires().stream().filter(destinataireDto -> destinataireDto.getEmail().equals(mailRequest.getDestination())).collect(Collectors.toList()));
            if(demandeDto.getDestinataires().get(0).getStatut().equals(EStatut.COMPLETE.name())){
                return new ResponseModelStandard<>("014");
            }else if(demandeDto.getDestinataires().get(0).getStatut().equals(EStatut.CANCELED.name())){
                return new ResponseModelStandard<>("015");
            }
            return new ResponseModelStandard<>("000", demandeDto);
        }else{
            return new ResponseModelStandard<>("012");
        }






    }






}
