package bmci.esign.backendend.services.impl;

import bmci.esign.backendend.dto.DemandeDto;
import bmci.esign.backendend.dto.DestinataireDto;
import bmci.esign.backendend.dto.ObjetSignatureDto;
import bmci.esign.backendend.dto.SignaturePageDto;
import bmci.esign.backendend.models.enums.EStatut;
import bmci.esign.backendend.services.DestinataireService;
import bmci.esign.backendend.services.UploadService;
import lombok.extern.slf4j.Slf4j;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.graphics.image.LosslessFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.UUID;

@Service
@Slf4j
public class UploadServiceImpl implements UploadService {
    @Value("${file.upload-dir.access}")
    private String UPLOAD_DIR;

    @Autowired
    private DestinataireService destinataireService;

    @Override
    public String uploadFile(MultipartFile file) {
        log.info("PROCESSING<>{uploadFile}... REQUEST: check_file {} ", file.isEmpty());
        try {
            String fileName = identifiant() + ".pdf";
            //file
            Path uploadPath = Paths.get(UPLOAD_DIR);
            if (!Files.exists(uploadPath)) {
                Files.createDirectories(uploadPath);
            }
            Path filePath = uploadPath.resolve(fileName);
            Files.copy(file.getInputStream(), filePath);
            return fileName;
        } catch (IOException ex) {
            return ex.getMessage();
        }
    }

    @Override
    public String modifyPdf(List<SignaturePageDto> signaturePageDtos, DemandeDto demandeDto) {
        String filename = demandeDto.getDocuments().get(0).getDirectory();
        DestinataireDto destinataireDto = demandeDto.getDestinataires().get(0);

        if (destinataireDto.getRole().equals("Signataire")) {
            try (PDDocument document = PDDocument.load(new File(UPLOAD_DIR + "/" + filename))) {
                for (SignaturePageDto signaturePageDto : signaturePageDtos) {
                    PDPage page = document.getPage(signaturePageDto.getPage());
                    log.info("Processing page: {}", signaturePageDto.getPage());
                    if (!signaturePageDto.getObjetSignatureDtos().isEmpty()) {
                        try (PDPageContentStream contentStream = new PDPageContentStream(document, page, PDPageContentStream.AppendMode.APPEND, true)) {
                            for (ObjetSignatureDto objetSignatureDto : signaturePageDto.getObjetSignatureDtos()) {
                                log.info("Processing object: type={}, x={}, y={}", objetSignatureDto.getTypeObjet(), objetSignatureDto.getX(), objetSignatureDto.getY());
                                        double x = resize(objetSignatureDto.getX(), 0.75);
                                        double y = resize(objetSignatureDto.getY(), 0.75);
                                        double width = resize(objetSignatureDto.getWidth(), 0.75);
                                        double height = resize(objetSignatureDto.getHeight(), 0.75);
                                      //  y = 841 - y;
                                        y = page.getMediaBox().getHeight() - y - height;
                                        log.info("PAGE_SIZE {}",page.getMediaBox().getHeight());
                                        x = Math.max(5, Math.min(x, PDRectangle.A4.getWidth() - width - 5));
                                        y = Math.max(height + 5, Math.min(y, PDRectangle.A4.getHeight() - height - 5));
                                        if ("NAME".equals(objetSignatureDto.getTypeObjet()) || "DATE".equals(objetSignatureDto.getTypeObjet())) {
                                            contentStream.beginText();
                                            contentStream.setFont(PDType1Font.TIMES_ROMAN, 12);
                                            contentStream.newLineAtOffset((float) x, (float) (y + height));
                                            contentStream.showText(objetSignatureDto.getText());
                                            contentStream.endText();
                                        } else {
                                            insertImage(document, contentStream, objetSignatureDto, x, y, width, height);
                                        }
                            }
                        }
                    }
                }
                document.save(UPLOAD_DIR + "/" + filename);
                destinataireDto.setStatut(EStatut.COMPLETE.name());
                destinataireService.updateDestinataire(destinataireDto, destinataireDto.getId());
                return "success";
            } catch (IOException e) {
                log.error("Error processing PDF: {}", e.getMessage(), e);
                destinataireDto.setStatut(EStatut.CANCELED.name());
                destinataireService.updateDestinataire(destinataireDto, destinataireDto.getId());
                return "cancel";
            }
        } else {
            destinataireDto.setStatut(EStatut.COMPLETE.name());
            destinataireService.updateDestinataire(destinataireDto, destinataireDto.getId());
            return "success";
        }
    }
    private void insertImage(PDDocument document, PDPageContentStream contentStream, ObjetSignatureDto objetSignatureDto, double x, double y, double width, double height) throws IOException {
        PDImageXObject pdImage = null;

        if (objetSignatureDto.getFileBase64() != null && !objetSignatureDto.getFileBase64().isEmpty()) {
            byte[] imageBytes = javax.xml.bind.DatatypeConverter.parseBase64Binary(objetSignatureDto.getFileBase64());
            BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(imageBytes));
            if (bufferedImage != null) {
                pdImage = LosslessFactory.createFromImage(document, bufferedImage);
            } else {
                log.error("BufferedImage is null for base64: {}", objetSignatureDto.getFileBase64());
            }
        } else if (objetSignatureDto.getFile() != null) {
            BufferedImage bImage = ImageIO.read(new File(String.valueOf(objetSignatureDto.getFile())));
            if (bImage != null) {
                pdImage = PDImageXObject.createFromByteArray(document, toByteArray(bImage), "image");
            } else {
                log.error("BufferedImage is null for file: {}", objetSignatureDto.getFile());
            }
        } else {
            log.error("No valid image source found for objetSignatureDto: {}", objetSignatureDto);
        }

        if (pdImage != null) {
            contentStream.drawImage(pdImage, (float) x, (float) y, (float) width, (float) height);
        }
    }

/*


               double y = resize(objetSignatureDto.getY(), 0.75);
                            double x = resize(objetSignatureDto.getX(), 0.75);
                            double width = resize(objetSignatureDto.getWidth(), 0.75);
                            double height = resize(objetSignatureDto.getHeight(), 0.75);
                            y = 841 - y;
                            log.info("Y {}",y);
                            if (x + width > PDRectangle.A4.getWidth()) {
                                x = (PDRectangle.A4.getWidth() - width) - 5;
                            } else if (x < 0) {
                                x = 5;
                            }
                            if ((y + height) > PDRectangle.A4.getHeight()) {
                                y = PDRectangle.A4.getHeight() - height - 5;
                            } else if (y < height) {
                                y = height + 5;
                            }

                            if (objetSignatureDto.getTypeObjet().equals("NAME") ||
                                    objetSignatureDto.getTypeObjet().equals("DATE")) {
                                // Add text
                                contentStream.beginText();
                                contentStream.setFont(PDType1Font.TIMES_ROMAN, 12);
                                contentStream.newLineAtOffset((float) x, (float) (y + height));
                                String text = objetSignatureDto.getText();
                                contentStream.showText(text);
                                contentStream.endText();
                            } else {
                                if (objetSignatureDto.getFileBase64() != null && !objetSignatureDto.getFileBase64().isEmpty()) {
                                    byte[] imageBytes = javax.xml.bind.DatatypeConverter.parseBase64Binary(objetSignatureDto.getFileBase64());
                                    BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(imageBytes));
                                    if (bufferedImage != null) {
                                        PDImageXObject pdImage = LosslessFactory.createFromImage(document, bufferedImage);
                                        log.warn("BASE64: selected x {}, y {}",(float) x, (float) y);
                                        contentStream.drawImage(pdImage, (float) x, (float) y, (float) width, (float) height);
                                    } else {
                                        log.error("BufferedImage is null for base64: {}", objetSignatureDto.getFileBase64());
                                        return "cancel";
                                    }
                                } else if (objetSignatureDto.getFile() != null) {
                                    BufferedImage bImage = ImageIO.read(new File(String.valueOf(objetSignatureDto.getFile())));
                                    if (bImage != null) {
                                        PDImageXObject pdImage = PDImageXObject.createFromByteArray(document, toByteArray(bImage), "image");
                                        log.warn("FILE: selected x {}, y {}",(float) x, (float) y);
                                        contentStream.drawImage(pdImage, (float) x, (float) y, (float) width, (float) height);
                                    } else {
                                        log.error("BufferedImage is null for file: {}", objetSignatureDto.getFile());
                                        return "cancel";
                                    }
                                } else {
                                    log.error("No valid image source found for objetSignatureDto: {}", objetSignatureDto);
                                }
                            }


    @Override
    public String modifyPdf(List<SignaturePageDto> signaturePageDtos, DemandeDto demandeDto) {
        String state = "";
        String filename = demandeDto.getDocuments().get(0).getDirectory();
        DestinataireDto destinataireDto = demandeDto.getDestinataires().get(0);
        if(destinataireDto.getRole().equals("Signataire")){
            try (
                    PDDocument document = PDDocument.load(new File(UPLOAD_DIR+"/"+ filename))) {
                PDPage page = new PDPage(PDRectangle.A4);
                for (SignaturePageDto signaturePageDto: signaturePageDtos){
                    page = document.getPage(signaturePageDto.getPage());
                    PDPageContentStream contentStream = new PDPageContentStream(document, page, PDPageContentStream.AppendMode.APPEND, true);
                    log.info("SIZE {}",signaturePageDto.getObjetSignatureDtos().size());
                    if(signaturePageDto.getObjetSignatureDtos().size() > 0){
                        for (ObjetSignatureDto objetSignatureDto:signaturePageDto.getObjetSignatureDtos()){
                            double y = resize(objetSignatureDto.getY(), 0.75);
                            double x = resize(objetSignatureDto.getX(),0.75);
                            double width = resize(objetSignatureDto.getWidth(), 0.75);
                            double height = resize(objetSignatureDto.getHeight(), 0.75);
                            y = 841 - y;
                            if(x+width > PDRectangle.A4.getWidth()){
                                x = (PDRectangle.A4.getWidth() - width) - 5;
                            }else if(x < 0) {
                                x = 5;
                            }
                            if((y+height) > PDRectangle.A4.getHeight()){
                                y = PDRectangle.A4.getHeight() - height - 5;
                            }
                            else if(y < height){
                                y = height + 5;
                            }

                            if(objetSignatureDto.getTypeObjet().equals("NAME") ||
                                    objetSignatureDto.getTypeObjet().equals("DATE")){
                                // Ajouter du texte
                                contentStream.beginText();
                                //Setting the font to the Content stream
                                contentStream.setFont(PDType1Font.TIMES_ROMAN, 12);
                                //Setting the position for the line
                                contentStream.newLineAtOffset((float) x, (float) (y+height));
                                String text = objetSignatureDto.getText();
                                //Adding text in the form of string
                                contentStream.showText(text);
                                //Ending the content stream
                                contentStream.endText();
                            }else{
                                if(!objetSignatureDto.getFileBase64().equals("") || objetSignatureDto.getFileBase64() != null){
                                    byte[] imageBytes = javax.xml.bind.DatatypeConverter.parseBase64Binary(objetSignatureDto.getFileBase64());
                                    BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(imageBytes));
                                    log.info("document: {} | bufferedImage: {}",document.getDocument(),bufferedImage);
                                    PDImageXObject pdImage = LosslessFactory.createFromImage(document, bufferedImage);
                                    contentStream.drawImage(pdImage, (float) x, (float) y,(float) width,(float) height);
                                }else if(objetSignatureDto.getFile() != null){
                                    BufferedImage bImage = ImageIO.read(new File(String.valueOf(objetSignatureDto.getFile())));
                                    PDImageXObject pdImage = PDImageXObject.createFromByteArray(document, toByteArray(bImage), "image");
                                    contentStream.drawImage(pdImage, (float) x, (float) y,(float) width,(float) height);
                                }
                            }
                        }
                    }
                    contentStream.close();
                    document.save(UPLOAD_DIR+"/"+filename);
                }

                destinataireDto.setStatut(EStatut.COMPLETE.name());
                destinataireService.updateDestinataire(destinataireDto, destinataireDto.getId());
                return "success";
            } catch (IOException e) {
                DestinataireDto destinataire = demandeDto.getDestinataires().get(0);
                destinataire.setStatut(EStatut.CANCELED.name());
                destinataireService.updateDestinataire(destinataire, destinataire.getId());
                e.printStackTrace();
            }
        }else{
            destinataireDto.setStatut(EStatut.COMPLETE.name());
            destinataireService.updateDestinataire(destinataireDto, destinataireDto.getId());
            return "success";
        }

        return "cancel";
    }

 */
    private static String identifiant(){
        return UUID.randomUUID().toString();
    }

    // Convertir BufferedImage en tableau de bytes
   private static byte[] toByteArray(BufferedImage image) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write(image, "jpg", baos);
        return baos.toByteArray();
   }

    private static double resize(double heigth, double pourcent){
        heigth = heigth * pourcent;
        return heigth;
    }

}

