package bmci.esign.backendend.services.impl;

import bmci.esign.backendend.dto.TypeDemandeDto;
import bmci.esign.backendend.dto.services.IMapClassWithDto;
import bmci.esign.backendend.models.TypeDemande;
import bmci.esign.backendend.repositories.TypeDemandeRepository;
import bmci.esign.backendend.services.TypeDemandeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class TypeDemandeServiceImpl implements TypeDemandeService {

    @Autowired
    private TypeDemandeRepository typeDemandeRepository;
    @Autowired
    private IMapClassWithDto<TypeDemande, TypeDemandeDto> typeDemandeMapping;

    @Override
    public TypeDemandeDto addTypeDemande(TypeDemandeDto typeDemandeDto) {
        TypeDemande typeDemande = typeDemandeMapping.convertToEntity(typeDemandeDto, TypeDemande.class);
        typeDemande = typeDemandeRepository.save(typeDemande);
        return typeDemandeMapping.convertToDto(typeDemande, TypeDemandeDto.class);
    }

    @Override
    public List<TypeDemandeDto> getAll() {
        List<TypeDemande> typeDemandes = typeDemandeRepository.findAll();
        return typeDemandeMapping.convertListToListDto(typeDemandes, TypeDemandeDto.class);
    }
}
