package bmci.esign.backendend.services.impl;

import bmci.esign.backendend.dto.DestinataireDto;
import bmci.esign.backendend.dto.DocumentDto;
import bmci.esign.backendend.dto.services.IMapClassWithDto;
import bmci.esign.backendend.models.Destinataire;
import bmci.esign.backendend.models.Document;
import bmci.esign.backendend.repositories.DocumentRepository;
import bmci.esign.backendend.services.DocumentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.print.Doc;
import java.util.List;

@Service
public class DocumentServiceImpl implements DocumentService {

    @Autowired
    private DocumentRepository documentRepository;

    @Autowired
    private IMapClassWithDto<Document, DocumentDto> documentMapping;

    @Override
    public DocumentDto addDocument(DocumentDto documentDto) {
        Document document = documentRepository.save(documentMapping.convertToEntity(documentDto, Document.class));
        return documentMapping.convertToDto(document, DocumentDto.class);
    }

    @Override
    public DocumentDto updateDocument(DocumentDto documentDto, Long id) {
        return null;
    }

    @Override
    public DocumentDto getDocument(Long id) {
        return null;
    }

    @Override
    public List<DocumentDto> findAllByDemandeId(Long id) {
        List<Document> documents = documentRepository.findAllByDemandeId(id);
        return documentMapping.convertListToListDto(documents, DocumentDto.class);
    }
}
