package bmci.esign.backendend.services.impl;

import bmci.esign.backendend.dto.DemandeDto;
import bmci.esign.backendend.dto.request.FilterDto;
import bmci.esign.backendend.dto.DestinataireDto;
import bmci.esign.backendend.dto.PositionDto;
import bmci.esign.backendend.dto.response.DashboardChart;
import bmci.esign.backendend.dto.services.IMapClassWithDto;
import bmci.esign.backendend.models.*;
import bmci.esign.backendend.models.enums.EDemande;
import bmci.esign.backendend.models.enums.ENotification;
import bmci.esign.backendend.models.enums.EStatut;
import bmci.esign.backendend.repositories.DemandeRepository;
import bmci.esign.backendend.repositories.DestinataireRepository;
import bmci.esign.backendend.repositories.DocumentRepository;
import bmci.esign.backendend.repositories.PositionRepository;
import bmci.esign.backendend.services.DemandeService;
import bmci.esign.backendend.services.EmailService;
import bmci.esign.backendend.services.NotificationService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import java.util.*;
import java.util.stream.Collectors;

@Service
@Slf4j
public class DemandeServiceImpl implements DemandeService {

    @Autowired
    private DemandeRepository demandeRepository;
    @Autowired
    private DestinataireRepository destinataireRepository;
    @Autowired
    private PositionRepository positionRepository;
    @Autowired
    private DocumentRepository documentRepository;
    @Autowired
    private EmailService emailService;
    @Autowired
    EntityManager entityManager;
    @Autowired
    private IMapClassWithDto<Demande, DemandeDto> demandeMapping;
    @Autowired
    private IMapClassWithDto<Destinataire, DestinataireDto> destinataireMapping;
    @Autowired
    private IMapClassWithDto<Position, PositionDto> positionMapping;
    @Autowired
    private NotificationService notificationService;

    @Override
    public DemandeDto addDemande(DemandeDto demandeDto) {
        log.info("PROCESSING<>{addDemande}... REQUEST_ID: {}", demandeDto.getId());
        List<DestinataireDto> destinataireDtos = demandeDto.getDestinataires();

        Demande demande = demandeMapping.convertToEntity(demandeDto, Demande.class);
        demande.setStatut(EStatut.WAITING);
        demande.setEdemande(EDemande.fromString(demandeDto.getStringDemand()));
        System.out.println(demande);
        demande = demandeRepository.save(demande);
        demandeDto = demandeMapping.convertToDto(demande, DemandeDto.class);

        if(demande.getDocuments().size() > 0){
            Optional<Document> document = demande.getDocuments().stream().findFirst();

            if(document.isPresent()){
                Demande demande1 = new Demande();
                demande1.setId(demande.getId());
                document.get().setDemande(demande1);
                documentRepository.save(document.get());
            }

        }
        for (DestinataireDto destinataireDto: destinataireDtos){
            destinataireDto.setStatut(EStatut.WAITING.name());
            destinataireDto.setDemande(demandeDto);
        }
        List<Destinataire> destinataires = destinataireRepository.saveAll(destinataireMapping.convertListToListEntity(destinataireDtos, Destinataire.class));

        for (DestinataireDto destinataireDto: destinataireDtos){
            for (PositionDto positionDto: destinataireDto.getPositions()){
                for (Destinataire destinataire: destinataires){
                    if(destinataire.getEmail().equals(destinataireDto.getEmail())){
                        Destinataire destinataire1 = new Destinataire();
                        destinataire1.setId(destinataire.getId());
                        positionDto.setDestinataire(destinataire1);
                        positionRepository.save(positionMapping.convertToEntity(positionDto, Position.class));
                    }
                }

            }
        }
        demande.setDestinataires(destinataires);
        processEmail(demande);
        return demandeDto;
    }

    @Override
    public DemandeDto updateDemande(DemandeDto demandeDto, Long id) {
        Optional<Demande> demande = demandeRepository.findById(id);
        if(demande.isPresent()){
            if(demandeDto.getId().equals(demande.get().getId())){
                Demande demande1 = demandeMapping.convertToEntity(demandeDto, Demande.class);
                demande1.setEdemande(EDemande.fromString(demandeDto.getStringDemand()));
                demande1.setStatut(EStatut.valueOf(demandeDto.getStatut()));
                demandeRepository.save(demande1);
                return demandeDto;
            }
        }
        return null;
    }

    @Override
    public DemandeDto getDemande(Long id) {
        log.info("PROCESSING<>{getDemande}... REQUEST_DM_ID: {}", id);
        Optional<Demande> demande = demandeRepository.findById(id);
        return demande.map(value -> demandeMapping.convertToDto(value, DemandeDto.class)).orElse(null);
    }

    @Override
    public Demande findDemande(Long id) {
        Optional<Demande> demande = demandeRepository.findById(id);
        return demande.orElse(null);
    }

    @Override
    public void processEmail(Demande demande) {
        log.info("PROCESSING<>{processEmail}...");
        List<Destinataire> destinataires = demande.getDestinataires().stream().filter(destinataire ->
                destinataire.getStatut().name().equals(EStatut.WAITING.name())).collect(Collectors.toList());

        if(demande.getEdemande().equals(EDemande.SEQUENCE) || demande.getEdemande().equals(EDemande.SIMULTANEE)){
            detectProcessActive(demande, destinataires);
            List<Destinataire> destinataireList = demande.getDestinataires().stream().filter(destinataire ->
                    destinataire.getStatut().name().equals(EStatut.COMPLETE.name())).collect(Collectors.toList());
            if(destinataireList.size() == demande.getDestinataires().size()){
                demande.setStatut(EStatut.COMPLETE);
                Optional<Demande> demande1 = demandeRepository.findById(demande.getId());
                if(demande1.isPresent()){
                    demande.setEdemande(demande1.get().getEdemande());
                    demandeRepository.save(demande);
                  //  notificationService.changeStatusByDmId(null, demande.getId(), ENotification.VIEW);
                }
            }
        }else if(demande.getEdemande().equals(EDemande.PARALLELE)){
            List<Destinataire> destinataireList = demande.getDestinataires().stream().filter(destinataire ->
                    destinataire.getStatut().name().equals(EStatut.COMPLETE.name())).collect(Collectors.toList());
            if(destinataireList.size() > 0){
                demande.setStatut(EStatut.COMPLETE);
                Optional<Demande> demande1 = demandeRepository.findById(demande.getId());
                if(demande1.isPresent()){
                    demande.setEdemande(demande1.get().getEdemande());
                    demandeRepository.save(demande);
                  //   notificationService.changeStatusByDmId(null, demande.getId(), ENotification.VIEW);
                }

            }else{
                detectProcessActive(demande, destinataires);
            }
        }else{

        }

    }

    private void detectProcessActive(Demande demande, List<Destinataire> destinataires) {
        if(destinataires.size() > 1){
            Destinataire destinataire = destinataires.stream().findFirst().get();
            for (Destinataire dest : destinataires){
                if(dest.getStatut().name().equals(EStatut.WAITING.name()) && dest.getPlace() == destinataire.getPlace()){
                    SendData(demande, dest, "bmci_t1");
                }
            }
        }else{
            for (Destinataire dest : destinataires){
                if(dest.getStatut().name().equals(EStatut.WAITING.name())){
                    SendData(demande, dest, "bmci_t1");
                }
            }
        }
    }

    @Override
    public String relaunchUser(Long idDemand, Long idDestinatiare) {
        try {
            Demande demande = findDemande(idDemand);
            Destinataire destinataire = demande.getDestinataires().stream().filter(destinataire1 -> destinataire1.getId().equals(idDestinatiare)).collect(Collectors.toList()).get(0);
            SendData(demande, destinataire, "bmci_t1");
            return "success";
        }catch (Exception e){
            return "failed";
        }

    }

    @Override
    public String cancelDemand(DemandeDto demandeDto) {
        try {
            demandeDto.setStatut(EStatut.CANCELED.name());
            EDemande eDemande = EDemande.valueOf(demandeDto.getStringDemand());
            demandeDto.setEdemande(eDemande.getDisplayName());
            updateDemande(demandeDto, demandeDto.getId());
            List<Destinataire> destinataires = destinataireRepository.findAllByDemandeId(demandeDto.getId());

            for(Destinataire destinataire : destinataires){
                if(destinataire.getStatut().equals(EStatut.WAITING)){
                    destinataire.setStatut(EStatut.CANCELED);
                    destinataireRepository.save(destinataire);
                }
            }
            return "success";
        }catch (Exception e){
            return "failed";
        }
    }

    private void SendData(Demande demande, Destinataire dest, String type) {
        MailRequest mailRequest = new MailRequest();
        Map<String,String> model = new HashMap<>();
        mailRequest.setDemandeId(demande.getId());
        mailRequest.setDestination(dest.getEmail());
        mailRequest.setName(dest.getName());
        mailRequest.setEmail_type(type);
        mailRequest.setExpiration_date(demande.getExpirationDate().toString());
        model.put("objet", demande.getObjetMail());
        model.put("message", demande.getMessage());
        model.put("name", dest.getName());
        emailService.SendEmail(mailRequest,model);
        String message = String.format("Cher %s, vous avez une nouvelle demande avec le sujet '%s'. Veuillez la consulter dès que possible.",
                                   demande.getUser().getLastname(),
                                   demande.getObjetMail());
        for(Destinataire destinataire : demande.getDestinataires()){
        notificationService.createNotification(new Notification(message, demande.getObjetMail(),destinataire,demande, ENotification.WAITING));

        }
}

    @Override
    public void deleteDemande(Long id) {

    }

    @Override
    public List<DemandeDto> getAll() {
        return null;
    }

    @Override
    public List<DemandeDto> getAllbyUser(Long userId) {
        List<Demande> demandes = demandeRepository.findAllByUserId(userId);
        return demandeMapping.convertListToListDto(demandes, DemandeDto.class);
    }

    @Override
    public Map<String, Object> getForUserDemandeSearch(Long userId, int page, int limit, String statut, String eDemande, Date dateStart) {
        log.info("PROCESSING<>{getForUserDemandeSearch}... REQUEST: userId {}; page {}; limit {}; ", userId, page, limit);
        Map<String, Object> resp = new HashMap<String, Object>();
        Calendar cal = Calendar.getInstance();
        cal.setTime(dateStart);
        cal.set(Calendar.HOUR_OF_DAY, 0);
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);
        cal.set(Calendar.MILLISECOND, 0);
        Date date_Start = cal.getTime();

        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery<Demande> criteriaQuery = criteriaBuilder.createQuery(Demande.class);

        Root<Demande> root = criteriaQuery.from(Demande.class);
        Predicate namePredicate = criteriaBuilder.and(
                criteriaBuilder.equal(criteriaBuilder.coalesce(criteriaBuilder.toLong(root.get("user").get("id")), 0L), userId),
                criteriaBuilder.lessThanOrEqualTo(root.get("creationDate"), date_Start));

        if(!statut.equals("")){
            namePredicate = criteriaBuilder.and(criteriaBuilder.equal(root.get("statut"), EStatut.fromString(statut)));
        }else if(!eDemande.equals("")){
            namePredicate = criteriaBuilder.and(criteriaBuilder.equal(root.get("edemande"), EDemande.fromString(eDemande)));
        }

        if(!statut.equals("") && !eDemande.equals("")){
            namePredicate = criteriaBuilder.and(criteriaBuilder.equal(root.get("statut"), EStatut.fromString(statut)) , criteriaBuilder.equal(root.get("edemande"), EDemande.fromString(eDemande)));
        }

        namePredicate = criteriaBuilder.and(namePredicate, criteriaBuilder.lessThanOrEqualTo(root.get("creationDate"), date_Start));
        criteriaQuery.where(namePredicate);
        criteriaQuery.orderBy(criteriaBuilder.desc(root.get("creationDate")));
        int firstResult = (page) * limit;
        TypedQuery<Demande> query = entityManager.createQuery(criteriaQuery).setMaxResults(limit).setFirstResult(firstResult);

        long total = 0;
        TypedQuery<Demande> countquery = entityManager.createQuery(criteriaQuery);
        total = countquery.getResultList().size();
        //  System.out.println("total : " + total);

        resp.put("data", demandeMapping.convertListToListDto(query.getResultList(), DemandeDto.class));
        resp.put("totalElements", total);

        return resp;

    }

// Received
    @Override
    @Transactional(readOnly = true)
    public Page<DemandeDto> findDemandesByUser(FilterDto filterDto){
        log.info("PROCESSING<>{findDemandesByUser}... REQUEST: {}", filterDto);
        try {
            int page = filterDto.getPage();
            int size = filterDto.getSize();
            Pageable pageable = PageRequest.of(page, size);
            Specification<Demande> specification = buildSpecification(filterDto);
            Page<Demande> demandePage= demandeRepository.findAll(specification, pageable);
            demandePage.stream().forEach(demande -> {
                demande.setDestinataires(mapDestinatairesToDto(demande.getDestinataires()));
            });
            return demandeMapping.convertResponseToPageDto(demandePage, DemandeDto.class);
        } catch (Exception e) {
            log.error("EXCEPTION<>findAllDemandesToSigne: {}", e.getMessage(), e);
            return Page.empty();
        }
    }

    private Specification<Demande> buildSpecification(FilterDto dto) {
        return (root, query, criteriaBuilder) -> {
            List<Predicate> predicates = new ArrayList<>();
            if (dto.getCreatedDate() != null) {
                log.info("creation_date: {}",dto.getCreatedDate());
                predicates.add(criteriaBuilder.equal(root.get("creation_date"), dto.getCreatedDate()));
            }
            if(dto.getPriority() != null){
                log.info("priority: {}",dto.getPriority());
                predicates.add(criteriaBuilder.equal(root.get("demande").get("priority"), dto.getPriority()));
            }
            predicates.add(criteriaBuilder.equal(root.get("user").get("email"), dto.getEmail()));

            return criteriaBuilder.and(predicates.toArray(new Predicate[0]));
        };
    }
    private List<Destinataire> mapDestinatairesToDto(List<Destinataire> destinataires) {
        return destinataires.stream()
                .map(dest -> new Destinataire(
                        dest.getId(),
                        dest.getName(),
                        dest.getEmail(),
                        dest.getRole(),
                        dest.getStatut(),
                        dest.getEnvoie(),
                        dest.getPlace(),
                        null,
                        dest.getCreationDate(),
                        dest.getModificationDate(),
                        Collections.emptyList()
                ))
                .collect(Collectors.toList());
    }

    @Override
    @Transactional(readOnly = true)
    public List<DashboardChart> loadReceivedChart(String email) {
        log.info("PROCESSING<>{Load_received_Request}... EMAIL: {}", email);
        try {
            if(email.isEmpty()){
                return null;
            }
            return demandeMapping.mappingData(demandeRepository.loadSignaturesChart(email));
        }catch (Exception e){
            log.error("EXCEPTION<>loadSignaturesChart: {}", e.getMessage(), e);
            return Collections.emptyList();
        }
    }

    @Override
    @Transactional(readOnly = true)
    public List<DashboardChart> loadGlobalData(String email) {
        log.info("PROCESSING<>{loadGlobalData}... EMAIL: {}", email);
        try {
            if(email.isEmpty()){
                return null;
            }
            return demandeRepository.loadSignaturesChart(email);
        }catch (Exception e){
            log.error("EXCEPTION<>loadSignaturesChart: {}", e.getMessage(), e);
            return Collections.emptyList();
        }
    }
}