package bmci.esign.backendend.services.impl;

import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.identity.User;
import org.springframework.stereotype.Service;

@Service
public class CamundaUserService {
    private final IdentityService identityService;
    public CamundaUserService(IdentityService identityService) {
        this.identityService = identityService;
    }

    public void createUser(String userId, String firstName, String lastName, String email, String password) {
        User user = identityService.newUser(userId);
        user.setFirstName(firstName);
        user.setLastName(lastName);
        user.setEmail(email);
        user.setPassword(password);

        identityService.saveUser(user);
    }

    public void updateUser(String userId, String newFirstName, String newLastName, String newEmail) {
    User user = identityService.createUserQuery().userId(userId).singleResult();
    if (user != null) {
        user.setFirstName(newFirstName);
        user.setLastName(newLastName);
        user.setEmail(newEmail);

        identityService.saveUser(user);
    }
}

}
