package bmci.esign.backendend.repositories;

import bmci.esign.backendend.dto.response.DashboardChart;
import bmci.esign.backendend.models.Destinataire;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Optional;

@Repository
public interface DestinataireRepository extends JpaRepository<Destinataire, Long>, JpaSpecificationExecutor<Destinataire> {
    List<Destinataire> findAllByDemandeId(Long id);

    @Query(value = "SELECT count(d.id) as count, d.statut as statut FROM Destinataire d WHERE d.email= :email GROUP BY d.statut")
    List<DashboardChart> loadSignDm(@Param("email") String email);
    Optional<Destinataire> findByEmail(String email);
}
