package bmci.esign.backendend.models.enums;

public enum EStatut {
    WAITING("En attente"),
    CANCELED("Expiré"),
    COMPLETE("Signé");

    private final String displayName;
    EStatut(String displayName) {
        this.displayName = displayName;
    }
    public String getDisplayName() {
        return displayName;
    }
    public static EStatut fromString(String text) {
        for (EStatut statut : EStatut.values()) {
            if (statut.displayName.equalsIgnoreCase(text)) {
                return statut;
            }
        }
        throw new IllegalArgumentException("No constant with text " + text + " found");
    }
}
