package bmci.esign.backendend.models;

import bmci.esign.backendend.models.enums.ENotification;
import lombok.*;

import javax.persistence.*;
import java.io.Serializable;

@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
@Entity
public class Notification extends AuditorEntity implements Serializable {

    private String title;
    private String message;

    @ManyToOne
    @JoinColumn(name = "destinataire_id")
    private Destinataire destinataire;

    @ManyToOne
    @JoinColumn(name = "demande_id")
    private Demande demande;

    @Enumerated(EnumType.STRING)
    @Column(length = 50)
    private ENotification status;

    @Override
    public String toString() {
        return "Notification{" +
                "title='" + title + '\'' +
                ", message='" + message + '\'' +
                ", destinataire_name=" + destinataire.getName() +
                ", demande_id=" + demande.getId() +
                ", status=" + status +
                ", id=" + id +
                ", creationDate=" + creationDate +
                ", modificationDate=" + modificationDate +
                '}';
    }
}
