package bmci.esign.backendend.models;


import bmci.esign.backendend.models.enums.EMailStatus;
import lombok.*;

import javax.persistence.*;
import java.io.Serializable;

@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
@Entity
public class MailRequest extends AuditorEntity implements Serializable {
    private String destination;
    private String email_type;
    private long demandeId;
    private String processCamundaId ;
    @Column(unique = true)
    private String token;
    private String expiration_date;
    private String name;
    private String userMessage;
    private EMailStatus status;
    private String responseMessage;
    private String url_sign;

    @Override
    public String toString() {
        return "MailRequest{" +
                "destination='" + destination + '\'' +
                ", email_type='" + email_type + '\'' +
                ", demandeId=" + demandeId +
                ", processCamundaId='" + processCamundaId + '\'' +
                ", token='" + token + '\'' +
                ", expiration_date='" + expiration_date + '\'' +
                ", name='" + name + '\'' +
                ", userMessage='" + userMessage + '\'' +
                ", status=" + status +
                ", responseMessage='" + responseMessage + '\'' +
                ", url_sign='" + url_sign + '\'' +
                ", id=" + id +
                ", creationDate=" + creationDate +
                ", modificationDate=" + modificationDate +
                '}';
    }
}
