package bmci.esign.backendend.controllers;

import bmci.esign.backendend.dto.UserDto;
import bmci.esign.backendend.models.ResponseModelStandard;
import bmci.esign.backendend.services.UserService;
import org.springframework.web.bind.annotation.*;

import java.nio.file.LinkOption;

@RestController
@RequestMapping("/user")
public class UserController {

    private final UserService userService;

    public UserController(UserService userService) {
        this.userService = userService;
    }

    @PostMapping("/add")
    public ResponseModelStandard<Long> addUser(@RequestBody UserDto userDto){
        userService.addUser(userDto);
        return new ResponseModelStandard<>("000");
    }

    @GetMapping("/get")
    public ResponseModelStandard<UserDto> getUser(@RequestParam(name = "email") String email){
        return new ResponseModelStandard<>("000", userService.findByEmail(email));
    }
}
