package bmci.esign.backendend.controllers;

import bmci.esign.backendend.dto.TypeDocumentDto;
import bmci.esign.backendend.dto.request.TypeDocAddDto;
import bmci.esign.backendend.models.ResponseModelStandard;
import bmci.esign.backendend.services.TypeDocumentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/TDocument")
public class TypeDocumentController {

    @Autowired
    private TypeDocumentService typeDocumentService;

    @GetMapping("/get")
    public ResponseModelStandard<List<TypeDocumentDto>> getAllTypeDocument(){
        try {
            List<TypeDocumentDto> typeDocumentDtos =  typeDocumentService.getAll();
            return new ResponseModelStandard<>("000", typeDocumentDtos);
        }catch (Exception e){
            return new ResponseModelStandard<>("099");
        }
    }

    @PostMapping("/add")
    public ResponseModelStandard<TypeDocumentDto> addTypeDocument(@RequestBody TypeDocAddDto type){
        try {
            TypeDocumentDto typeDocumentDtos =  typeDocumentService.addTypeDocument(type);
            return new ResponseModelStandard<>("000", typeDocumentDtos);
        }catch (Exception e){
            return new ResponseModelStandard<>("099");
        }
    }
}
