package bmci.esign.backendend.controllers;

import bmci.esign.backendend.dto.DemandeDto;
import bmci.esign.backendend.models.MailRequest;
import bmci.esign.backendend.models.ResponseModelStandard;
import bmci.esign.backendend.models.enums.EMailStatus;
import bmci.esign.backendend.models.enums.EStatut;
import bmci.esign.backendend.repositories.MailRequestRepository;
import bmci.esign.backendend.services.DemandeService;
import org.springframework.web.bind.annotation.*;

import java.util.Date;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/token")
public class TokenController {

    private final MailRequestRepository mailRequestRepository;
    private final DemandeService demandeService;

    public TokenController(MailRequestRepository mailRequestRepository, DemandeService demandeService) {
        this.mailRequestRepository = mailRequestRepository;
        this.demandeService = demandeService;
    }


    @GetMapping("/getToken")
    public ResponseModelStandard<DemandeDto> getToken(@RequestParam(name = "token") String token){

        MailRequest mailRequest = mailRequestRepository.findByToken(token);
        if(mailRequest != null){
            if(mailRequest.getStatus().equals(EMailStatus.SENT)){
                mailRequest.setStatus(EMailStatus.CLICKED);
                mailRequestRepository.save(mailRequest);
            }
            DemandeDto demandeDto = demandeService.getDemande(mailRequest.getDemandeId());
            if(demandeDto.getStatut().equals(EStatut.COMPLETE.name())){
                return new ResponseModelStandard<>("014");
            }else if(demandeDto.getStatut().equals(EStatut.CANCELED.name())){
                return new ResponseModelStandard<>("015");
            }
            if(demandeDto.getExpirationDate().compareTo(new Date()) < 0){
                return new ResponseModelStandard<>("013");
            }
        demandeDto.setDestinataires(
                demandeDto.getDestinataires().stream().filter(destinataireDto -> destinataireDto.getEmail().equals(mailRequest.getDestination())).collect(Collectors.toList()));
            if(demandeDto.getDestinataires().get(0).getStatut().equals(EStatut.COMPLETE.name())){
                return new ResponseModelStandard<>("014");
            }else if(demandeDto.getDestinataires().get(0).getStatut().equals(EStatut.CANCELED.name())){
                return new ResponseModelStandard<>("015");
            }
            return new ResponseModelStandard<>("000", demandeDto);
        }else{
            return new ResponseModelStandard<>("012");
        }






    }






}
