package bmci.esign.backendend.controllers;

import bmci.esign.backendend.dto.PositionDto;
import bmci.esign.backendend.models.ResponseModelStandard;
import bmci.esign.backendend.services.PositionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/position")
public class PositionController {

    @Autowired
    private PositionService positionService;


    @PostMapping("/add")
    public ResponseModelStandard<Long> addPosition(@RequestBody PositionDto positionDto){
        positionService.addPosition(positionDto);
        return new ResponseModelStandard<>("000");
    }


    @GetMapping("/getByDestinataire")
    public ResponseModelStandard<List<PositionDto>> findAllByDestinataire(@RequestParam(name = "id") Long id){
        List<PositionDto> positionDtos = positionService.findAllByDestinataireId(id);
        return new ResponseModelStandard<>("000", positionDtos);
    }



}
