package bmci.esign.backendend.controllers;

import bmci.esign.backendend.dto.DemandeDto;
import bmci.esign.backendend.dto.DestinataireDto;
import bmci.esign.backendend.dto.request.FilterDto;
import bmci.esign.backendend.dto.response.DashboardChart;
import bmci.esign.backendend.models.ResponseModelStandard;
import bmci.esign.backendend.services.DestinataireService;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/destinataire")
public class DestinataireController {
    private final DestinataireService destinataireService;

    public DestinataireController(DestinataireService destinataireService) {
        this.destinataireService = destinataireService;
    }

    @PostMapping("/addAll")
    public ResponseModelStandard<Long> addAllDestinataire(@RequestBody List<DestinataireDto> destinataireDtos){
        List<DestinataireDto> list = destinataireService.addAll(destinataireDtos);
        return new ResponseModelStandard<>("000");
    }

    @PostMapping("/add")
    public ResponseModelStandard<Long> addDestinataire(@RequestBody DestinataireDto destinataireDto){
        DestinataireDto destinataire = destinataireService.addDestinataire(destinataireDto);
        return new ResponseModelStandard<>("000");
    }

    @GetMapping("/get")
    public ResponseModelStandard<List<DestinataireDto>> findAllByDemandeId(@RequestParam(name = "id") Long id){
        List<DestinataireDto> destinataireDtos = destinataireService.findAllByDemandeId(id);
        return new ResponseModelStandard<>("000", destinataireDtos);
    }

    @PostMapping("/signer")
    public ResponseModelStandard<Page<DemandeDto>> getDemandesToSign(@RequestBody FilterDto destinataireFilterDto){
        try {
            Page<DemandeDto> demandeDtoList = destinataireService.findAllDemandesToSigne(destinataireFilterDto);
            return new ResponseModelStandard<>("000",demandeDtoList);
        }catch (Exception e){
            return new ResponseModelStandard<>("099");
        }
    }

    @GetMapping("/chart")
    public ResponseModelStandard<List<DashboardChart>> chartDMSign(@RequestParam(name = "email") String email){
         try {
                 List<DashboardChart> dashboardCharts =destinataireService.loadSignDmChart(email);
                 if(dashboardCharts == null){
                         return new ResponseModelStandard<>("099","Missing data");
                 }
                 return new ResponseModelStandard<>("000", dashboardCharts);
         }catch (Exception e){
                 return new ResponseModelStandard<>("099");
         }
    }
}