package bmci.esign.backendend.controllers;

import bmci.esign.backendend.dto.AuthorityDto;
import bmci.esign.backendend.models.Authority;
import bmci.esign.backendend.models.ResponseModelStandard;
import bmci.esign.backendend.services.AuthorityService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/authority")
public class AuthorityController {

    @Autowired
    private AuthorityService authorityService;

    @GetMapping("/get")
    public ResponseModelStandard<List<AuthorityDto>> getAll(){
        return new ResponseModelStandard<>("000", authorityService.getAll());
    }
    @PostMapping("/create")
    public ResponseModelStandard<Authority> createAuthority(@RequestBody Authority authority) {
        try {
             Authority response= authorityService.addAuthority(authority);
             return new ResponseModelStandard<>("000", response);
        }catch (Exception e){
             return new ResponseModelStandard<>("099");
         }
    }

}
