package bmci.esign.backendend.controllers;


import bmci.esign.backendend.dto.SignatureDto;
import bmci.esign.backendend.models.ResponseModelStandard;
import bmci.esign.backendend.services.SignatureService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/signature")
public class SignatureController {

    @Autowired
    private SignatureService signatureService;

    @PostMapping("/add")
    public ResponseModelStandard<Long> addSignature(@RequestBody SignatureDto signatureDto){
        try {
            signatureService.addSignature(signatureDto);
            return new ResponseModelStandard<>("000");
        }catch (Exception e){
            return new ResponseModelStandard<>("099");
        }
    }


    @GetMapping("/get")
    public ResponseModelStandard<List<SignatureDto>> getSignature(@RequestParam(name = "id") Long id){
        try {
            List<SignatureDto> signatureDtos =  signatureService.findAllByUserId(id);
            return new ResponseModelStandard<>("000", signatureDtos);
        }catch (Exception e){
            return new ResponseModelStandard<>("099");
        }
    }


}
