package bmci.esign.backendend.controllers;

import bmci.esign.backendend.dto.NotificationDto;
import bmci.esign.backendend.dto.request.UserEmailRequest;
import bmci.esign.backendend.models.Notification;
import bmci.esign.backendend.models.ResponseModelStandard;
import bmci.esign.backendend.models.enums.ENotification;
import bmci.esign.backendend.services.NotificationService;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/notifications")
public class NotificationController {
    private final NotificationService notificationService;
    public NotificationController(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    @PostMapping("/create")
    public ResponseModelStandard<Notification> createNotification(@RequestBody Notification notification) {
        try {
             Notification response= notificationService.createNotification(notification);
             return new ResponseModelStandard<>("000", response);
        }catch (Exception e){
             return new ResponseModelStandard<>("099");
         }
    }

    @PostMapping("/user/active")
    public ResponseModelStandard<List<NotificationDto>> loadActiveNotificationsByUserEmail(@RequestBody UserEmailRequest userEmailRequest) {
         try {
             List<NotificationDto> notifications= notificationService.loadActiveNotificationsByUserEmail(userEmailRequest.getEmail());
             return new ResponseModelStandard<>("000", notifications);
         }catch (Exception e){
             return new ResponseModelStandard<>("099");
         }
    }

    @PostMapping("/update/status")
    public ResponseModelStandard<NotificationDto> updateStatus(@RequestParam Long id) {
         try {
             notificationService.changeStatusByDmId(id, null,ENotification.VIEW);
             return new ResponseModelStandard<>("000");
         }catch (Exception e){
             return new ResponseModelStandard<>("099");
         }
    }
}
