package com.example.skyapi.service.impl;

import com.example.skyapi.helper.User;
import com.example.skyapi.repository.UserRepository;
import com.example.skyapi.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Random;
import java.util.UUID;

@Service
public class UserServiceImpl implements UserService {

    @Autowired
    UserRepository userRepository;

    @Override
    public User addUser(User user) {
        String identifiant = identifiant();
        user.setIdentifiant(identifiant);
        return userRepository.save(user);
    }

    @Override
    public User login(String email, String password) {
        return userRepository.findByEmailAndPassword(email, password);
    }

    @Override
    public User findByEmail(String email) {
        return userRepository.findByEmail(email);
    }

    @Override
    public User findByIdentifiant(String identifiant) {
        return userRepository.findByIdentifiant(identifiant);
    }


    private static String identifiant(){
        return UUID.randomUUID().toString();
    }
}
