package com.example.skyapi.service.impl;

import com.example.skyapi.helper.Config;
import com.example.skyapi.helper.Folder;
import com.example.skyapi.helper.Image;
import com.example.skyapi.helper.Report;
import com.example.skyapi.service.ApiService;
import com.google.gson.JsonObject;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;




@Service
public class ApiServiceImpl  implements ApiService {

    @Value("${file.upload-dir.folder}")
    private String DIRECTORY;
    static final Config config = new Config();

    @Override
    public List<Folder> getFolders() {
        List<Folder> folderList = new ArrayList<>();
        try {
         List<String> stringList = config.getFolder(DIRECTORY);
         if(!stringList.isEmpty()){
             for (String list : stringList){
                 folderList.add(new Folder(list));
             }
         }
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        return folderList;
    }

    @Override
    public List<Image> getImages(Folder folder) {
        List<Image> imageList = new ArrayList<>();
        try {
            HashMap<String, List<String>> folderImages = config.getFolderAndImage(DIRECTORY);
            folderImages.forEach((s, strings) -> {
                if(s.equals(folder.getName())){
                    for (String data: strings){
                        imageList.add(new Image(data));
                    }
                }
            });

        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        return imageList;
    }

    @Override
    public Image getImage(Image image) {
        return null;
    }

    @Override
    public List<Image> getFolderAndImageFile(Folder folder) {
        List<Image> files = new ArrayList<>();
        try {
            HashMap<String, List<Image>> folderList = config.getFolderAndImageFile(DIRECTORY);
            folderList.forEach((s, strings) -> {
                if(s.equals(folder.getName())){
                    for (Image image : strings){
                        image.setBase64(Base64.getEncoder().encodeToString(image.getFile()));
                    }
                    files.addAll(strings);
                }
            });
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        return files;
    }

    @Override
    public JsonObject writeInFile(Report report) {
        JsonObject jsonObject = new JsonObject();
        JsonObject jsonObjectAll = new JsonObject();
        if(config.verifyFileIfexistBoolean("report", DIRECTORY+report.getName())){
            jsonObjectAll = config.getFileTxt(report.getName() +"/report.txt",DIRECTORY);
            jsonObject.addProperty("state", report.getState());
            jsonObjectAll.getAsJsonObject().add(report.getIdentifiant(), jsonObject);
            config.saveFile(jsonObjectAll,report.getName()+"/report", DIRECTORY);
        }else{
            jsonObject.addProperty("state", report.getState());
            jsonObjectAll.add(report.getIdentifiant(), jsonObject);
            config.saveFile(jsonObjectAll,report.getName()+"/report", DIRECTORY);
        }
        return jsonObject;
    }

    @Override
    public JsonObject getSetting(String name) {
        JsonObject jsonObjectText = new JsonObject();
        if(config.verifyFileIfexistBoolean("report", DIRECTORY+name)){
            jsonObjectText = config.getFileTxt(name +"/report.txt",DIRECTORY);
        }else
        {
            jsonObjectText.addProperty("state", "null");
        }
        return jsonObjectText;
    }


}
