package com.example.skyapi.helper;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import org.springframework.boot.ansi.AnsiColor;
import org.springframework.boot.ansi.AnsiOutput;

import java.io.*;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Config {

    public Config() {
    }

    public List<String> getFolder(String rootDirectoryPath) throws IOException {
        List<String> directoryNames = new ArrayList<String>();
        Path rootDirectory = Paths.get(rootDirectoryPath);
        Files.list(rootDirectory).forEach(path -> {
            directoryNames.add(path.getFileName().toString());
        });
        return directoryNames;
    }

    public HashMap<String, List<String>> getFolderAndImage(String rootDirectoryPath) throws IOException {
        List<String> directoryNames = new ArrayList<String>();
        HashMap<String,List<String>> directoryNamesAndFileNames = new HashMap<>();
        Path rootDirectory = Paths.get(rootDirectoryPath);
        Files.list(rootDirectory).forEach(path -> {
            if (Files.isDirectory(path)) {
                    directoryNames.add(rootDirectoryPath+path.getFileName().toString());
                    String directoryofFiles = rootDirectoryPath+path.getFileName().toString();
                    List<String> fileNames = new ArrayList<>();
                    try {
                        Path directory = Paths.get(directoryofFiles);
                        if (Files.isDirectory(directory)) {
                            System.out.println("Searching directory: " + directoryofFiles);
                            Files.list(directory).forEach(filePath -> {
                                if (Files.isRegularFile(filePath)) {
                                    System.out.println(filePath);
                                    System.out.println("Found file: " + filePath.getFileName().toString());
                                    fileNames.add(filePath.getFileName().toString());
                                } else {
                                    System.out.println("Ignoring non-regular file: " + filePath.getFileName().toString());
                                }
                            });
                            directoryNamesAndFileNames.put(path.getFileName().toString(),fileNames);
                        } else {
                            System.out.println("Skipping non-directory: " + directoryofFiles);
                        }
                    } catch (IOException ex) {
                        System.out.println("Error accessing directory: " + directoryofFiles);

                    }
                }
        });

        return directoryNamesAndFileNames;
    }


    public HashMap<String, List<Image>> getFolderAndImageFile(String rootDirectoryPath) throws IOException {
        List<String> directoryNames = new ArrayList<String>();
        HashMap<String,List<Image>> directoryNamesAndFileNames = new HashMap<>();
        Path rootDirectory = Paths.get(rootDirectoryPath);
        Files.list(rootDirectory).forEach(path -> {
            if (Files.isDirectory(path)) {
                directoryNames.add(rootDirectoryPath+path.getFileName().toString());
                String directoryofFiles = rootDirectoryPath+path.getFileName().toString();
                List<Image> fileNames = new ArrayList<>();
                try {
                    Path directory = Paths.get(directoryofFiles);
                    if (Files.isDirectory(directory)) {
                        System.out.println("Searching directory: " + directoryofFiles);
                        Files.list(directory).forEach(filePath -> {
                            if (Files.isRegularFile(filePath)) {
                                System.out.println("Found file: " + filePath.getFileName().toString());
                                System.out.println(filePath);
                                try {
                                    byte[] imageBytes = Files.readAllBytes(filePath);
                                    Image image = new Image(filePath.getFileName().toString());
                                    image.setFile(imageBytes);
                                    fileNames.add(image);
                                } catch (IOException e) {
                                    throw new RuntimeException(e);
                                }

                            } else {
                                System.out.println("Ignoring non-regular file: " + filePath.getFileName().toString());
                            }
                        });
                        directoryNamesAndFileNames.put(path.getFileName().toString(),fileNames);
                    } else {
                        System.out.println("Skipping non-directory: " + directoryofFiles);
                    }
                } catch (IOException ex) {
                    System.out.println("Error accessing directory: " + directoryofFiles);

                }
            }
        });

        return directoryNamesAndFileNames;
    }

    public JsonObject saveFile(JsonObject jsonObject, String namefile, String path) {
            String newNameFile = namefile+"."+"txt";
            Gson gson = new Gson();
            String jsonString = gson.toJson(jsonObject);
            try (FileWriter fileWriter = new FileWriter(path + newNameFile)) {
                fileWriter.write(jsonString);
            } catch (IOException e) {
                e.printStackTrace();
            }

        return jsonObject;
    }

    public JsonObject getFileTxt(String nameFIle, String path) {
        String newNameFile = nameFIle;
        File file = null;
        JsonObject jsonObject = null;
        Gson gson = new Gson();
        try {
            file = new File(path + newNameFile);
        } catch (Exception e) {
            e.printStackTrace();
        }
            try (BufferedReader reader = new BufferedReader(new FileReader(file))) {
                StringBuilder sb = new StringBuilder();
                String line;
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                }
                jsonObject = gson.fromJson(sb.toString(), JsonObject.class);
            } catch (IOException e) {
                e.printStackTrace();
            }

        return jsonObject;
    }


    public boolean verifyFileIfexistBoolean(String name,String path){
        File folder = new File(path);
        String[] listOfFiles = folder.list();
        boolean  found = false;
        try {
            for (String n:listOfFiles){
                int dotIndex = n.toString().lastIndexOf('.');
                if (dotIndex == -1) {
                    System.out.println(n);
                } else {
                    n=n.toString().substring(0, dotIndex);
                }
                if (n.equals(name)){
                    found=true;
                }
            }
        }catch (Exception e){
            found = false;
        }

        return found;
    }


}
