package com.example.skyapi.controller;

import com.example.skyapi.helper.Folder;
import com.example.skyapi.helper.Image;
import com.example.skyapi.helper.Report;
import com.example.skyapi.helper.User;
import com.example.skyapi.service.ApiService;
import com.example.skyapi.service.UserService;
import com.google.gson.JsonObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;

@RestController()
@RequestMapping("/api")
@CrossOrigin(origins = "*")
public class SkyController {

    @Autowired
    private ApiService apiService;
    @Autowired
    private UserService userService;

    @GetMapping("/getFolder")
    public List<Folder> getFolders () {
        List<Folder> folderList = apiService.getFolders();
        return folderList;
    }

    @GetMapping("/getFolder/images")
    public List<Image> getFoldersImages (@RequestParam("name") String name) {
        Folder folder = new Folder(name);
        List<Image> imageList = apiService.getImages(folder);
        return imageList;
    }


    @GetMapping("/getImage")
    public Image getImage (@RequestParam("name") String name) {
        Image image = new Image(name);
        image = apiService.getImage(image);
        return image;
    }

    @GetMapping("/imageName")
    public ResponseEntity<byte[]> getImageData(@RequestParam("directory") String directory) {
        Path desktopPath = Paths.get(System.getProperty("user.home"), "Desktop\\indatacore\\mattel\\");
        Path imagePath = desktopPath.resolve(directory);
        try {
            if (Files.exists(imagePath) && Files.isRegularFile(imagePath)) {
                byte[] imageBytes = Files.readAllBytes(imagePath);
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.IMAGE_JPEG);
                return new ResponseEntity<>(imageBytes, headers, HttpStatus.OK);
            } else {
                return new ResponseEntity<>(HttpStatus.NOT_FOUND);
            }
        } catch (IOException e) {
            e.printStackTrace();
            return new ResponseEntity<>(HttpStatus.NOT_FOUND);
        }
    }


    @GetMapping("/files")
    public List<Image> getFiles(@RequestParam("directory") String directory) {
        return apiService.getFolderAndImageFile(new Folder(directory));
    }


    @GetMapping("/report")
    public ResponseEntity<JsonObject> saveReport(@RequestParam("name") String name, @RequestParam("state") String state,
                                                 @RequestParam("identifiant") String identifiant) {
        Report report = new Report(name, state, identifiant);
        JsonObject jsonObject = apiService.writeInFile(report);
        return new ResponseEntity<>(jsonObject, HttpStatus.OK);
    }

    @GetMapping("/getSetting")
    public ResponseEntity<JsonObject> getSetting(@RequestParam("name") String name) {
        JsonObject jsonObject = apiService.getSetting(name);
        return new ResponseEntity<>(jsonObject, HttpStatus.OK);
    }


    @PostMapping("/addUser")
    public ResponseEntity<User> addUser(@RequestBody User user) {
        User user1 = userService.login(user.getEmail(), user.getPassword());
        if(user1 != null){
            return new ResponseEntity<>(user1, HttpStatus.OK);
        }else{
            User user2 = userService.findByEmail(user.getEmail());
            if(user2 != null){
              return new ResponseEntity<>(user, HttpStatus.OK);
            }else{
                user = userService.addUser(user);
                return new ResponseEntity<>(user, HttpStatus.OK);
            }
        }
    }


}
