package com.iam.ldapbackend;


import java.util.ArrayList;
import java.util.List;

import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;

import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

import javax.net.ssl.X509TrustManager;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.ldap.core.AttributesMapper;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.ldap.filter.AndFilter;
import org.springframework.ldap.filter.EqualsFilter;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.ldap.authentication.LdapAuthenticationProvider;
import org.springframework.security.ldap.authentication.LdapAuthenticator;
import org.springframework.security.ldap.userdetails.PersonContextMapper;
import org.springframework.stereotype.Service;



@Service
public class LdapTest {

    // public boolean login(String username, String password) {

    //     AndFilter filter = new AndFilter();

    //     LdapContextSource contextSource = new LdapContextSource();

    //     System.out.println("------->>>>>> "+ldpaBase+"// "+ldpaURL+"// "+"// ");

    //     contextSource.setUrl(ldpaURL);

    //     contextSource.setBase(ldpaBase);

    //     contextSource.afterPropertiesSet();

    //     LdapTemplate lt = new LdapTemplate(contextSource);

    //     lt.setIgnorePartialResultException(true);
    //     // Active Directory doesn’t transparently handle referrals. This fixes that.


    //     filter.and(new EqualsFilter("userPrincipalName", username));

    //     return lt.authenticate("ou=people",
    //             filter.toString(), password);

    // }

    public void authenticate(String username, String password) {

        LdapContextSource contextSource = new LdapContextSource();

        contextSource.setUrl(ldpaURL);

        contextSource.setBase(ldpaBase);

        contextSource.setUserDn(ldpaBase);

        contextSource.afterPropertiesSet();

        contextSource
                .getContext(
                        "uid=" +
                                username +
                                "," +
                                ldpaBase, password);
                                
    }

    public void authenticateSimpleAdmin(String username, String password) throws Exception {

        LdapContextSource contextSource = new LdapContextSource();

        contextSource.setUrl(ldpaURL);

        contextSource.setBase(ldpaBase);

        // contextSource.setUserDn(ldpaBase);

        contextSource.setUserDn("cn=DIGI_VENTE,DC=iamdg,DC=net,DC=ma");

        contextSource.setPassword("926$8af$MC");
 
        contextSource.afterPropertiesSet();

        HttpsURLConnection https = getHttpsConnexion();

        https.connect();

        contextSource
                .getContext(
                        "uid=" +
                                username +
                                "," +
                                ldpaBase, password);

        https.disconnect();
    }

    public void authenticate2(String username, String password, String ou) {

        try{

            LdapContextSource contextSource = new LdapContextSource();

            contextSource.setUrl(ldpaURL);

            contextSource.setBase(ldpaBase);

            contextSource.afterPropertiesSet();

            contextSource
                    .getContext(
                            "uid=" +
                                    username +
                                    ",ou="+ou+"," +
                                    ldpaBase, password);

        }catch(Exception ex){
            ex.printStackTrace();
        }

       
    }

    public void authenticateWithAdmin(String username, String password, String ou) throws Exception {

        LdapContextSource contextSource = new LdapContextSource();

        contextSource.setUrl(ldpaURL);

        contextSource.setBase(ldpaBase);

        contextSource.setUserDn("cn=DIGI_VENTE,DC=iamdg,DC=net,DC=ma");

        contextSource.setPassword("926$8af$MC");

        contextSource.afterPropertiesSet();

        HttpsURLConnection https = getHttpsConnexion();

        https.connect();

        contextSource
                .getContext(
                        "uid=" +
                                username +
                                ",ou="+ou+"," +
                                ldpaBase, password);


        https.disconnect();


    }

 
    public List<String> search(String username) throws Exception {

        LdapContextSource contextSource = new LdapContextSource();

        contextSource.setUrl(ldpaURL);

       contextSource.setBase(ldpaBase);

       contextSource.setUserDn("cn=DIGI_VENTE,DC=iamdg,DC=net,DC=ma");

        contextSource.setPassword("926$8af$MC");

        contextSource.afterPropertiesSet();

        LdapTemplate lt = new LdapTemplate(contextSource);

        HttpsURLConnection https = getHttpsConnexion();

        https.connect();

        try {
            lt.afterPropertiesSet();
            return lt
          .search(
            "", 
            "uid=" + username, 
            (AttributesMapper<String>) attrs -> (String)( attrs.toString()));

        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
            List l = new ArrayList<>();
            l.add("error : "+e.getMessage());
            return l;
        }
        finally{
            https.disconnect();
        }
        
    }


    public List searchCustome(String username) throws Exception {

        LdapContextSource contextSource = new LdapContextSource();

        contextSource.setUrl(ldpaURL);

       contextSource.setBase(ldpaBase);

        contextSource.afterPropertiesSet();

        LdapTemplate lt = new LdapTemplate(contextSource);


        // try {


        //     Attributes xx = contextSource.getReadOnlyContext().getAttributes("uid=joe,ou=otherpeople");

        //     System.out.println("JOE LDAP ATTRIBUTES : "+xx.toString());


        // } catch (NamingException e1) {
        //     // TODO Auto-generated catch block
        //     e1.printStackTrace();
        // }

        HttpsURLConnection https = getHttpsConnexion();

        https.connect();

        try {

            List persons = new ArrayList();
            try {
                List search = lt.search("", "(objectClass=person)", (AttributesMapper<String>) attrs -> (String)attrs.toString());
                persons.addAll(search);
            } catch (Exception e) {
                System.out.println("Error: " + e);
            }

            return persons;


        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
            List l = new ArrayList<>();
            l.add("error : "+e.getMessage());
            return l;
        }finally{
            https.disconnect();
        }

        

        
    }


    public List searchGroups(String objectClass) {

        LdapContextSource contextSource = new LdapContextSource();

        contextSource.setUrl(ldpaURL);

       contextSource.setBase(ldpaBase);

        contextSource.afterPropertiesSet();

        LdapTemplate lt = new LdapTemplate(contextSource);


        try {

            List search = null;
      
            try {

                 search = lt.search("", "(objectClass="+objectClass+")", (AttributesMapper<String>) attrs -> (String)attrs.toString());
             

                System.out.println();
            } catch (Exception e) {
                System.out.println("Error: " + e);
            }

            return search;


        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
            List l = new ArrayList<>();
            l.add("error : "+e.getMessage());
            return l;
        }

        

        
    }


    @Value("${spring.ldap.base}")
    String ldpaBase;
    @Value("${spring.ldap.url}")
    String ldpaURL;


    private HttpsURLConnection getHttpsConnexion() throws Exception {

        
        HttpsURLConnection https = null;

        

     SSLContext sslCon = SSLContext.getInstance("SSL");

     TrustManager[] trustAll = new TrustManager[]{
         new TrustAllCerts()
     };

     sslCon.init(null, trustAll, new SecureRandom());

    https.setDefaultSSLSocketFactory(sslCon.getSocketFactory());

     URL url;
     
     url = new URL("https://10.100.11.2:636");
   
    https = (HttpsURLConnection) url.openConnection();

    https.setHostnameVerifier(new TrustAllHosts());

    return https;
}

public class TrustAllHosts implements HostnameVerifier {

    @Override
    public boolean verify(String arg0, SSLSession arg1) {
        // TODO Auto-generated method stub
        return true;
    }
    
}


public class TrustAllCerts implements X509TrustManager {

    @Override
    public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        // TODO Auto-generated method stub
        
    }

    @Override
    public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        // TODO Auto-generated method stub
        
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        // TODO Auto-generated method stub
        return null;
    }
    
}

//    @Value("${spring.ldap.username}")
//    String ldpaPrinciple;
//    @Value("${spring.ldap.password}")
//    String ldpaPass;


    // LdapTemplate ldapTemplate(){
    //   return new LdapTemplate(contextSource());
    // }

    // @Bean
    // public LdapContextSource contextSource() {

    //     LdapContextSource contextSource = new LdapContextSource();

    //     System.out.println("------->>>>>> "+ldpaBase+"// "+ldpaURL+"// "+"// ");

    //     contextSource.setUrl(ldpaURL);

    //    // contextSource.setBase(ldpaBase);

    //     contextSource.afterPropertiesSet();

    //     return contextSource;
    // }



    // public class PersonAttributesMapper implements AttributesMapper{

    //     @Override
    //     public Object mapFromAttributes(Attributes attributes) throws NamingException {
    //         AppUserMobile user = new AppUserMobile();
            
    //         Attribute name = attributes.get("name");
    //         if (name != null){
                
    //             user.setAddress((String) name.get());
    //         }
    
    //         Attribute displayname = attributes.get("cn");
    //         if (displayname != null){
    //             user.setEmail((String) displayname.get());
    //         }
    
    //         Attribute lastname = attributes.get("sn");
    //         if (lastname != null){
    //             user.setLastName((String) lastname.get());
    //         }
    
    //         Attribute firstname = attributes.get("ou");
    //         if (firstname != null){
    //             user.setFirstName((String) firstname.get());
    //         }
    
    //         Attribute mail = attributes.get("mail");
    //         if (mail != null){
    //             user.setEmail((String) mail.get());
    //         }
   
    //         Attribute userid = attributes.get("uid");
    //         if (userid != null){
    //             user.setId((String) userid.get());
    //         }
    
    //         System.out.println(user.toString());
    
    //         return user;
    //     }
    // }
}
