package com.iam.ldapbackend;


import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin(methods = {RequestMethod.GET, RequestMethod.PUT})
@RestController
@RequestMapping("tools")
public class ToolsController {


    @Autowired
    LdapTest ldapTest;


    @GetMapping("checkLdapUser")
    public ResponseEntity authLdap22(@RequestParam String uid, @RequestParam  String password){

        try{

            ldapTest.authenticate(uid, password);
           
        }catch (Exception e0){
            e0.printStackTrace();
            return ResponseEntity.ok("nook");
        }

        return ResponseEntity.ok("ok");
    }

    @GetMapping("checkLdapUser1")
    public ResponseEntity authLdap11(@RequestParam String uid, @RequestParam  String password){

        try{

            ldapTest.authenticateSimpleAdmin(uid, password);
           
        }catch (Exception e0){
            e0.printStackTrace();
            return ResponseEntity.ok("nook");
        }

        return ResponseEntity.ok("ok");
    }

    @GetMapping("checkLdapUser2")
    public ResponseEntity authLdap33(@RequestParam String uid, @RequestParam  String password, @RequestParam  String ou){

        try{

            ldapTest.authenticate2(uid, password, ou);
           
        }catch (Exception e0){
            e0.printStackTrace();
            return ResponseEntity.ok("nook");
        }

        return ResponseEntity.ok("ok");
    }

    @GetMapping("checkLdapUserAdmin")
    public ResponseEntity authLdapAdmin(@RequestParam String uid, @RequestParam  String password, @RequestParam  String ou){

        try{

            ldapTest.authenticateWithAdmin(uid, password, ou);
           
        }catch (Exception e0){
            e0.printStackTrace();
            return ResponseEntity.ok("nook");
        }

        return ResponseEntity.ok("ok");
    }

    @GetMapping("ldapsearchuser")
    public ResponseEntity serchLdap(@RequestParam String uid){

        try{

            List d = ldapTest.search(uid);

            String sss = "";

            for(Object o : d){

                sss += (o).toString();
            }

            return ResponseEntity.ok(sss);
           
        }catch (Exception e0){
            e0.printStackTrace();
            return ResponseEntity.ok("nook");
        }

        

        
    }

    @GetMapping("ldapgroups")
    public ResponseEntity ldapgroups(@RequestParam String objectClass){

        try{

            List d = ldapTest.searchGroups(objectClass);

            String sss = "";

            for(Object o : d){

                System.out.println("OBject = "+o.toString()+"\n");
                    sss += o.toString();
               // sss += ((AppUserMobile)o).getLastName() + " // "+((AppUserMobile)o).getId()+ " // "+((AppUserMobile)o).getLastName();
            }

            return ResponseEntity.ok(sss);
           
        }catch (Exception e0){
            e0.printStackTrace();
            return ResponseEntity.ok("nook");
        }

        
    }

}
